#!/usr/bin/perl
use strict;
use Data::Dumper;

my $pi = atan2(1,1) * 4;

sub calc_sine_area {
  my @ret;
  my $num = shift();
  my $min = (1 - cos(1.0/$num * $pi)) / 2;
  my $max = (1 - cos(($num-1)/$num * $pi)) / 2;
  for( my $pos = 1.0/$num.0; $pos < ($num-1)/$num; $pos += 1.0/$num ) {
    my $val = ((1 - cos($pos * $pi)) / 2 - $min) / ($max - $min);
    my $ival = 255-int($val*255+0.5);
    push @ret, $ival unless( $ival == 0 );
  }
  return @ret;
}

sub calc_triangle_area {
  my @ret;
  my $num = shift()-2;
  for( my $i = 0; $i < $num; ++$i ) {
    push @ret, (255.5 - 255 * $i / $num)>>0;
  }
  return @ret;
}

sub calc_nearest_table {
  my @ret;
  my $input = shift;
  for( my $i = 0; $i < 256; ++$i ) {
    my $mindiff = 256;
    my $closest;
    for( my $j = 0; $j < @$input; ++$j ) {
      my $diff = $input->[$j] - $i;
      $diff = -$diff if( $diff < 0 );
      if( $diff < $mindiff ) {
        $mindiff = $diff;
        $closest = $j;
      }
    }
    if( $i < $input->[@$input-1]/2 ) {
      push @ret, 255;
    } else {
      push @ret, $closest+1;
    }
  }
  return @ret;
}

sub print_c_uchar_array {
  my $name = shift();
  my $data = shift();
  my $len = scalar(@$data);
  print "static const unsigned char ".$name."[".$len."] = { ".join(", ", @$data)." };\n";
}

my @sine_area = calc_sine_area(21);
my @triangle_area = calc_triangle_area(21);
my @sine_table = calc_nearest_table(\@sine_area);
my @triangle_table = calc_nearest_table(\@triangle_area);
print_c_uchar_array("sine_area", \@sine_area);
print_c_uchar_array("triangle_area", \@triangle_area);
print_c_uchar_array("sine_table", \@sine_table);
print_c_uchar_array("triangle_table", \@triangle_table);
